import asyncio
import json

from py_pli.pylib import VUnits, send_msg
import time

async def scantable_movement(time_to_wait=1):

    msg = {'result': f'Start heatmap_scantable_movement'}
    await send_msg(json.dumps(msg))
    st = VUnits.instance.hal.scan_table
    st.ReloadConfig()
    await st.InitializeDevice()

    position_list = [[0, 0],
                     [85, 0],
                     [170, 0],
                     [170, 85],
                     [85, 85],
                     [0, 85],
                     [0, 170],
                     [85, 170],
                     [170, 170]]

    for position in position_list:

        msg_text = f'Move to Position {position}'
        msg = {'result': f'{msg_text}'}
        await send_msg(json.dumps(msg))
        await st.Move(position[0], position[1])
        msg = {'result': f'wait {time_to_wait}s...'}
        await send_msg(json.dumps(msg))
        await asyncio.sleep(time_to_wait)
    msg = {'result': f'finished !'}
    await send_msg(json.dumps(msg))
